/*
 * Decompiled with CFR 0.152.
 */
package robotsfights;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import robotsfights.GamePanel;
import robotsfights.robot.Robot;

public class Game
extends JFrame {
    private GamePanel gamePanel;
    private boolean inGame;
    private JLabel bestRobotLabel;
    private JLabel gameLabel;
    private JLabel jLabel3;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JPanel jPanel1;
    private JPopupMenu.Separator jSeparator1;
    private JPanel statusPanel;

    public Game() {
        this.initComponents();
        this.gamePanel = new GamePanel();
        this.setPreferredSize(new Dimension(500, 500));
        this.setSize(new Dimension(500, 500));
        this.jPanel1.add((Component)this.gamePanel, "Center");
        this.inGame = false;
        this.initGame();
    }

    private void initGame() {
        this.inGame = false;
        this.gamePanel.addRobot(new Robot(15, 20, Color.yellow, "Arthur"), 100, 100);
        this.gamePanel.addRobot(new Robot(20, 20, Color.orange, "X3PO"), 130, 180);
        this.gamePanel.addRobot(new Robot(10, 10, Color.cyan, "R2D2"), 230, 280);
        this.gamePanel.addRobot(new Robot(15, 10, Color.red, "Billy"), 200, 170);
        this.gamePanel.addRobot(new Robot(20, 15, Color.blue, "BLUA"), 130, 230);
        this.gamePanel.addRobot(new Robot(16, 10, Color.GREEN, "Grass47"), 230, 380);
        this.gamePanel.addRobot(new Robot(20, 18, Color.gray, "Fad2"), 420, 230);
        this.gamePanel.addRobot(new Robot(12, 10, Color.pink, "Porcinet"), 400, 380);
        Random ran = new Random();
        for (Robot r : this.gamePanel.getRobots()) {
            r.setSpeedX((int)(ran.nextDouble() * 10.0) - 5);
            r.setSpeedY((int)(ran.nextDouble() * 10.0) - 5);
        }
    }

    public void startGame() {
        this.inGame = true;
        new Thread(new Runnable(){

            public void run() {
                Game.this.inGame = true;
                while (Game.this.gamePanel.getRobots().size() > 1 && Game.this.inGame) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    new Thread(new Runnable(){

                        public void run() {
                            Game.this.gamePanel.repaint();
                        }
                    }).start();
                    Game.this.getGameLabel().setText(Game.this.gamePanel.getRobots().size() + " / " + Game.this.gamePanel.getFights() + " combats");
                    Game.this.getBestRobotLabel().setText(Game.this.gamePanel.getBestRobot().getName());
                }
                Game.this.inGame = false;
                Game.this.getGameLabel().setText(Game.this.gamePanel.getRobots().size() + " / " + Game.this.gamePanel.getFights() + " combats     --> FINI !!");
            }
        }).start();
    }

    public JLabel getBestRobotLabel() {
        return this.bestRobotLabel;
    }

    public JLabel getGameLabel() {
        return this.gameLabel;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.statusPanel = new JPanel();
        this.gameLabel = new JLabel();
        this.bestRobotLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem4 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Robots Fights");
        this.setBackground(new Color(0, 0, 0));
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.jPanel1.setBackground(new Color(0, 0, 0));
        this.jPanel1.setForeground(new Color(0, 255, 0));
        this.jPanel1.setLayout(new BorderLayout());
        this.statusPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.statusPanel.setMinimumSize(new Dimension(150, 25));
        this.statusPanel.setOpaque(false);
        this.statusPanel.setPreferredSize(new Dimension(400, 25));
        this.statusPanel.setLayout(new BorderLayout());
        this.gameLabel.setFont(new Font("Tahoma", 1, 11));
        this.gameLabel.setForeground(new Color(255, 255, 255));
        this.gameLabel.setText("X / X combats");
        this.gameLabel.setToolTipText("Compte rendu du jeu en cours");
        this.statusPanel.add((Component)this.gameLabel, "Center");
        this.bestRobotLabel.setForeground(new Color(255, 255, 255));
        this.bestRobotLabel.setText("Best !");
        this.statusPanel.add((Component)this.bestRobotLabel, "After");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("Robots : ");
        this.statusPanel.add((Component)this.jLabel3, "Before");
        this.jPanel1.add((Component)this.statusPanel, "South");
        this.getContentPane().add(this.jPanel1);
        this.jMenu1.setText("Jeu");
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.jMenuItem2.setText("D\u00e9marrer");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Game.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem5.setText("Arr\u00eater");
        this.jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Game.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem3.setText("Apport en robots");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Game.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu1.add(this.jSeparator1);
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItem4.setText("Quitter");
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Game.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("?");
        this.jMenuItem1.setText("MalchroSoft");
        this.jMenu2.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.startGame();
        this.jMenuItem2.setEnabled(false);
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.initGame();
        this.jMenuItem2.setEnabled(true);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.inGame = false;
        this.jMenuItem2.setEnabled(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Game().setVisible(true);
            }
        });
    }
}

