/*
 * Decompiled with CFR 0.152.
 */
package chronos;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.swingx.JXPanel;

public class ChronosPanel
extends JXPanel {
    private final SimpleDateFormat fmt;
    private Thread chronoThread;
    private Date dateToReach;
    private boolean running;
    private JFrame parent;
    private JFormattedTextField dateText;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JProgressBar pb;
    private JButton startButton;
    private JLabel timeLabel;

    public ChronosPanel(JFrame parent) {
        this.parent = parent;
        this.fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        this.initComponents();
        this.setPreferredSize(new Dimension(350, 200));
        this.dateText.setText(this.fmt.format(new Date(new Date().getTime() + 0x6DDD00L)));
        this.running = false;
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChronosPanel.this.startButton.getText().toUpperCase().equals("START")) {
                    ChronosPanel.this.startAction();
                } else {
                    ChronosPanel.this.stopAction();
                }
            }
        });
    }

    private void startAction() {
        this.dateToReach = null;
        try {
            this.dateToReach = this.fmt.parse(this.dateText.getText());
        }
        catch (ParseException ex) {
            this.dateToReach = new Date(new Date().getTime() + 172800000L);
            this.dateText.setText(this.fmt.format(this.dateToReach));
        }
        this.startButton.setText("STOP");
        this.startButton.setForeground(new Color(255, 0, 0));
        this.chronoThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int hours = 0;
                int minutes = 0;
                int secs = 0;
                int days = 0;
                int months = 0;
                int year = 0;
                long startTime = (System.currentTimeMillis() - ChronosPanel.this.dateToReach.getTime()) / 1000L;
                if (startTime < 0L) {
                    startTime = -startTime;
                }
                long time = startTime;
                while (ChronosPanel.this.running) {
                    String rest = "";
                    time = (System.currentTimeMillis() - ChronosPanel.this.dateToReach.getTime()) / 1000L;
                    if (time < 0L) {
                        time = -time;
                    }
                    if (time < 1L) {
                        ChronosPanel.this.stopAction();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(ChronosPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ChronosPanel.this.goToIn(new Point((int)ChronosPanel.this.parent.getLocation().getX(), (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight()), 500, 3);
                    } else if (time % 3600L == 0L) {
                        ChronosPanel.this.goToIn(new Point((int)ChronosPanel.this.parent.getLocation().getX(), (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight()), 300, 1);
                    } else if (time < 5L) {
                        ChronosPanel.this.vibroInThread((int)(20L - time));
                    } else if (time < 60L) {
                        ChronosPanel.this.vibroInThread(10);
                    } else if (time < 3600L) {
                        ChronosPanel.this.glingItInThread(0);
                    } else if (time < 18000L) {
                        ChronosPanel.this.glingItInThread((int)(time / 4000L));
                    } else if (time < 86400L) {
                        ChronosPanel.this.glingItInThread((int)(time / 5000L));
                    } else if (time < 172800L) {
                        ChronosPanel.this.glingItInThread(secs * 2);
                    }
                    ChronosPanel.this.pb.setValue((int)(time * 100L / startTime));
                    year = (int)((double)time / 3.15576E7);
                    if (year >= 2) {
                        rest = rest + year + "ans ";
                        time = (long)((double)time - (double)year * 3.15576E7);
                    } else if (year >= 1) {
                        rest = rest + year + "an ";
                        time = (long)((double)time - (double)year * 3.15576E7);
                    }
                    months = (int)(time / 2592000L);
                    if (months >= 1) {
                        rest = rest + months + "mois ";
                        time -= (long)(months * 2592000);
                    }
                    if ((days = (int)(time / 86400L)) >= 1) {
                        rest = rest + days + "j ";
                        time -= (long)(days * 86400);
                    }
                    hours = (int)(time / 3600L);
                    rest = rest + hours + ":";
                    minutes = (int)((time -= (long)(hours * 3600)) / 60L);
                    rest = rest + minutes + ":";
                    secs = (int)(time -= (long)(minutes * 60));
                    rest = rest + secs + "s";
                    ChronosPanel.this.pb.repaint();
                    ChronosPanel.this.timeLabel.setText(rest);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    ChronosPanel.this.parent.setTitle(rest + " - MalchroSoft Chronos");
                }
            }
        });
        this.chronoThread.start();
        this.running = true;
    }

    private void stopAction() {
        this.startButton.setText("START");
        this.startButton.setForeground(new Color(0, 255, 0));
        this.chronoThread.interrupt();
        this.chronoThread = null;
        this.running = false;
    }

    public void glingItInThread(final int resistance) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ChronosPanel.this.glingIt(resistance);
            }
        }).start();
    }

    public synchronized void vibroInThread(final int n) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ChronosPanel.this.treatVibro(n);
            }
        }).start();
    }

    private void glingIt(int resitance) {
        Point p = this.parent.getLocation();
        if (resitance < 1) {
            resitance = 1;
        }
        int move = 20 / resitance;
        for (int i = 0; i < 20; ++i) {
            this.parent.setLocation((int)p.getX() + move, (int)p.getY() + move);
            this.parent.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            move = -move / 2;
        }
        this.parent.setLocation(p);
    }

    private void treatVibro(int n) {
        Rectangle originalBound = this.parent.getBounds();
        Rectangle bound = this.parent.getBounds();
        for (int i = 0; i < n; ++i) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (i % 2 == 0) {
                bound.setLocation(Math.round((float)bound.getX()) + 10, Math.round((float)bound.getY()) + 5);
            } else {
                bound.setLocation(Math.round((float)bound.getX()) - 10, Math.round((float)bound.getY()) - 5);
            }
            this.parent.setBounds(bound);
            this.parent.repaint();
        }
        this.parent.setBounds(originalBound);
    }

    private synchronized void goToIn(final Point p, int sec, int rebonds) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (p.getX() + (double)this.getWidth() > d.getWidth()) {
            p.setLocation(d.getWidth() - (double)this.getWidth(), p.getY());
        }
        if (p.getY() + (double)this.getHeight() > d.getHeight()) {
            p.setLocation(p.getX(), d.getHeight() - (double)this.getHeight());
        }
        final Point cp = new Point();
        final Point origP = this.parent.getLocation();
        Animator a = new Animator(sec, rebonds * 2, Animator.RepeatBehavior.REVERSE, new TimingTargetAdapter(){

            @Override
            public void timingEvent(float fraction) {
                cp.setLocation(Math.min(p.getX(), origP.getX()) + (Math.max(p.getX(), origP.getX()) - Math.min(p.getX(), origP.getX())) * (double)fraction, Math.min(p.getY(), origP.getY()) + (Math.max(p.getY(), origP.getY()) - Math.min(p.getY(), origP.getY())) * (double)fraction);
                ChronosPanel.this.parent.setLocation((int)cp.getX(), (int)cp.getY());
            }

            @Override
            public void begin() {
            }

            @Override
            public void end() {
            }
        });
        a.setAcceleration(0.2f);
        a.setStartDirection(Animator.Direction.FORWARD);
        a.setStartFraction(0.0f);
        a.start();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.pb = new JProgressBar();
        this.startButton = new JButton();
        this.timeLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.dateText = new JFormattedTextField();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.jPanel2.setMaximumSize(new Dimension(32000, 25));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.pb.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.jPanel2.add(this.pb);
        this.jPanel1.add(this.jPanel2);
        this.startButton.setText("Start");
        this.startButton.setToolTipText("Mise en route");
        this.jPanel1.add(this.startButton);
        this.add((Component)this.jPanel1, "Last");
        this.timeLabel.setBackground(new Color(255, 255, 255));
        this.timeLabel.setFont(new Font("Mandela", 1, 36));
        this.timeLabel.setHorizontalAlignment(0);
        this.timeLabel.setText("0s");
        this.timeLabel.setOpaque(true);
        this.add((Component)this.timeLabel, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jLabel1.setText(" Date :");
        this.jPanel3.add((Component)this.jLabel1, "Before");
        this.dateText.setForeground(new Color(102, 102, 102));
        this.dateText.setFormatterFactory(new DefaultFormatterFactory(new DateFormatter(new SimpleDateFormat("dd/MM/yyyy HH:mm"))));
        this.dateText.setText("31/07/2010 00:00");
        this.dateText.setToolTipText("Date \u00e0 atteindre");
        this.dateText.setCursor(new Cursor(2));
        this.dateText.setFont(new Font("Lucida Console", 1, 14));
        this.jPanel3.add((Component)this.dateText, "Center");
        this.add((Component)this.jPanel3, "First");
    }
}

