/*
 * Decompiled with CFR 0.152.
 */
package com.malchrosoft.filesorter.graphic;

import com.malchrosoft.debug.Log;
import com.malchrosoft.filesorter.constant.HtmlColor;
import java.io.StringReader;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;

public class ConsoleViewManager {
    private HTMLEditorKit kit;
    private Document doc;

    public ConsoleViewManager(HTMLEditorKit editorKit, Document doc) {
        this.doc = doc;
        this.kit = editorKit;
    }

    public final void append(String text, boolean isHTML) {
        if (isHTML) {
            this.append(text);
        }
        this.append(text, HtmlColor.BLACK);
    }

    public final void append(String text, HtmlColor color) {
        this.append("<div style=\"float: left; color: " + color.getColor() + ";\">" + text + "</span>");
    }

    public final void append(String text, HtmlColor foreground, HtmlColor background) {
        this.append("<span style=\"float: left; color: " + foreground.getColor() + "; background-color: " + background.getColor() + " \">" + text + "</span>");
    }

    public final void newLine() {
        this.append("<br />");
    }

    public final void appendLine(String text) {
        this.append(text, false);
        this.newLine();
    }

    public final void appendLine(String text, HtmlColor color) {
        this.append(text, color);
        this.newLine();
    }

    public final void appendLine(String text, HtmlColor foreground, HtmlColor background) {
        this.append(text, foreground, background);
        this.newLine();
    }

    public final void append(String fullHTML) {
        this.append(fullHTML, 0);
    }

    public final void append(String fullHtml, int beforeEnd) {
        if (fullHtml == null || fullHtml.equals("")) {
            return;
        }
        try {
            StringReader r = new StringReader(fullHtml);
            this.kit.read(r, this.doc, this.doc.getLength() - beforeEnd);
        }
        catch (Exception e) {
            Log.error(e.getLocalizedMessage());
        }
    }
}

